import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Define the figure and axis
fig, ax = plt.subplots(figsize=(12, 10))

# Colors for the statuses
floor_color = "lightgrey"
passenger_color = "blue"
empty_elevator_color = "green"
partially_full_elevator_color = "yellow"
full_elevator_color = "red"

# Define the floors
floor_height = 1
floor_width = 10
num_floors = 5

# Draw floors
for i in range(num_floors):
    ax.add_patch(patches.Rectangle((0, i), floor_width, floor_height, edgecolor='black', facecolor=floor_color))
    ax.text(0.5, i + 0.5, f'floor_{i}', verticalalignment='center', horizontalalignment='center', fontsize=10, color='black')

# Define passengers
passenger_positions = {
    'p2': (0.5, 0),
    'p3': (1, 0),
    'p0': (0.5, 1),
    'p5': (1, 1),
    'p1': (0.5, 3),
    'p4': (1, 3)
}

# Draw passengers
for p_id, (x, y) in passenger_positions.items():
    ax.add_patch(patches.Rectangle((x, y + 0.25), 0.3, 0.5, edgecolor='black', facecolor=passenger_color))
    ax.text(x + 0.15, y + 0.5, p_id, verticalalignment='center', horizontalalignment='center', fontsize=8, color='white')

# Define elevators
elevator_positions = {
    'fast0': (8.5, 0, empty_elevator_color, '0/2'),
    'fast1': (9.2, 0, empty_elevator_color, '0/2'),
    'slow0-0': (7.5, 0, empty_elevator_color, '0/1'),
    'slow1-0': (7.5, 2, empty_elevator_color, '0/1')
}

# Draw elevators
for e_id, (x, y, color, status) in elevator_positions.items():
    ax.add_patch(patches.Rectangle((x, y + 0.25), 0.6, 0.5, edgecolor='black', facecolor=color))
    ax.text(x + 0.3, y + 0.5, f'{e_id}\n{status}', verticalalignment='center', horizontalalignment='center', fontsize=8, color='white')

# Legend
legend_elements = [
    patches.Patch(facecolor=passenger_color, edgecolor='black', label='Passenger'),
    patches.Patch(facecolor=empty_elevator_color, edgecolor='black', label='Empty Elevator'),
    patches.Patch(facecolor=partially_full_elevator_color, edgecolor='black', label='Partially Full Elevator'),
    patches.Patch(facecolor=full_elevator_color, edgecolor='black', label='Full Elevator')
]
ax.legend(handles=legend_elements, loc='upper right', bbox_to_anchor=(1.25, 1))

# Set limits and hide axes
ax.set_xlim(-1, floor_width + 2)
ax.set_ylim(-1, num_floors)
ax.axis('off')

# Save the figure
plt.savefig('elevator/one_shot/ini_diagram_code/attempts/attempt_2.png', bbox_inches='tight')
plt.show()